% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_conversion_dendrogram.R
\name{as.Node.dendrogram}
\alias{as.Node.dendrogram}
\title{Convert a \code{\link{dendrogram}} to a data.tree \code{Node}}
\usage{
\method{as.Node}{dendrogram}(x, name = "root", heightName = "plotHeight",
  ...)
}
\arguments{
\item{x}{The dendrogram}

\item{name}{The name of the root Node}

\item{heightName}{The name under which the dendrogram's height is stored}

\item{...}{Additional parameters}
}
\value{
The root \code{Node} of a \code{data.tree}
}
\description{
Convert a \code{\link{dendrogram}} to a data.tree \code{Node}
}
\examples{
hc <- hclust(dist(USArrests), "ave")
dend1 <- as.dendrogram(hc)
tree1 <- as.Node(dend1)
tree1$fieldsAll
tree1$totalCount
tree1$leafCount
tree1$height
  
}
\seealso{
Other as.Node: \code{\link{as.Node.data.frame}},
  \code{\link{as.Node.list}}, \code{\link{as.Node.phylo}},
  \code{\link{as.Node}}
}

