% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_conversion_party.R
\name{as.Node.party}
\alias{as.Node.party}
\title{Convert a a \code{party} from the partykit package to a \code{data.tree} structure.}
\usage{
\method{as.Node}{party}(x, ...)
}
\arguments{
\item{x}{The party object}

\item{...}{other arguments (unused)}
}
\description{
Convert a a \code{party} from the partykit package to a \code{data.tree} structure.
}
\examples{
library(partykit)
data("WeatherPlay", package = "partykit")
### splits ###
# split in overcast, humidity, and windy
sp_o <- partysplit(1L, index = 1:3)
sp_h <- partysplit(3L, breaks = 75)
sp_w <- partysplit(4L, index = 1:2)

## query labels
character_split(sp_o)

### nodes ###
## set up partynode structure
pn <- partynode(1L, split = sp_o, kids = list(
  partynode(2L, split = sp_h, kids = list(
      partynode(3L, info = "yes"),
      partynode(4L, info = "no"))),
  partynode(5L, info = "yes"),
  partynode(6L, split = sp_w, kids = list(
      partynode(7L, info = "yes"),
      partynode(8L, info = "no")))))
pn
### tree ###
## party: associate recursive partynode structure with data
py <- party(pn, WeatherPlay)
tree <- as.Node(py)

print(tree, 
      "splitname",
      count = function(node) nrow(node$data), 
      "splitLevel")

SetNodeStyle(tree, 
             label = function(node) paste0(node$name, ": ", node$splitname), 
             tooltip = function(node) paste0(nrow(node$data), " observations"),
             fontname = "helvetica")
SetEdgeStyle(tree, 
             arrowhead = "none", 
             label = function(node) node$splitLevel,
             fontname = "helvetica",
             penwidth = function(node) 12 * nrow(node$data)/nrow(node$root$data),
             color = function(node) {
               paste0("grey", 
                      100 - as.integer( 100 * nrow(node$data)/nrow(node$root$data))
                      )
             }
             )
Do(tree$leaves, 
   function(node) {
     SetNodeStyle(node, 
                  shape = "box", 
                  color = ifelse(node$splitname == "yes", "darkolivegreen4", "lightsalmon4"),
                  fillcolor = ifelse(node$splitname == "yes", "darkolivegreen1", "lightsalmon"),
                  style = "filled,rounded",
                  penwidth = 2
                  )
   }
   )

plot(tree)


}

