% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_conversion_ape.R
\name{GetPhyloNr}
\alias{GetPhyloNr}
\title{Determine the number a \code{Node} has after conversion to a phylo object}
\usage{
GetPhyloNr(x, type = c("node", "edge"))
}
\arguments{
\item{x}{The Node}

\item{type}{Either "node" (the default) or "edge" (to get the number of the edge from \code{x} to its parent)}
}
\value{
an integer representing the node
}
\description{
Use this function when plotting a Node as a phylo, e.g. to set custom
labels to plot.
}
\examples{
library(ape)
library(data.tree)
data(acme)
ap <- as.phylo(acme)
plot(ap)
nodelabels("IT Dep.", GetPhyloNr(Climb(acme, "IT")))
edgelabels("Good!", GetPhyloNr(Climb(acme, "IT", "Switch to R"), "edge"))

}
\seealso{
Other ape phylo conversions: \code{\link{as.Node.phylo}},
  \code{\link{as.phylo.Node}}
}

