% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_conversion_ape.R
\name{as.Node.phylo}
\alias{as.Node.phylo}
\title{Convert a \code{phylo} object from the ape package to a \code{Node}}
\usage{
\method{as.Node}{phylo}(x, heightName = "plotHeight",
  replaceUnderscores = TRUE, ...)
}
\arguments{
\item{x}{The phylo object to be converted}

\item{heightName}{If the phylo contains edge lengths, then they will be converted
to a height and stored in a field named according to this parameter (the default is "height")}

\item{replaceUnderscores}{if TRUE (the default), then underscores in names are replaced with spaces}

\item{...}{any other parameter to be passed to sub-implementations}
}
\description{
Convert a \code{phylo} object from the ape package to a \code{Node}
}
\examples{
#which bird familes have the max height?
library(ape)
data(bird.families)
bf <- as.Node(bird.families)
height <- bf$height
t <- Traverse(bf, filterFun = function(x) x$level == 25)
Get(t, "name")

}
\seealso{
Other ape phylo conversions: \code{\link{GetPhyloNr}},
  \code{\link{as.phylo.Node}}

Other as.Node: \code{\link{as.Node.data.frame}},
  \code{\link{as.Node.dendrogram}},
  \code{\link{as.Node.list}}, \code{\link{as.Node}}
}

