% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataops_filter.R
\name{drFilter}
\alias{drFilter}
\title{Filter a 'ddo' or 'ddf' Object}
\usage{
drFilter(x, filterFn, output = NULL, overwrite = FALSE, params = NULL,
  packages = NULL, control = NULL)
}
\arguments{
\item{x}{an object of class 'ddo' or 'ddf'}

\item{filterFn}{function that takes either a key-value pair (as two arguments) or just a value (as a single argument) and returns either \code{TRUE} or \code{FALSE} - if \code{TRUE}, that key-value pair will be present in the result. See examples for details.}

\item{output}{a "kvConnection" object indicating where the output data should reside (see \code{\link{localDiskConn}}, \code{\link{hdfsConn}}).  If \code{NULL} (default), output will be an in-memory "ddo" object.}

\item{overwrite}{logical; should existing output location be overwritten? (also can specify \code{overwrite = "backup"} to move the existing output to _bak)}

\item{params}{a named list of objects external to the input data that are needed in the distributed computing (most should be taken care of automatically such that this is rarely necessary to specify)}

\item{packages}{a vector of R package names that contain functions used in \code{filterFn} (most should be taken care of automatically such that this is rarely necessary to specify)}

\item{control}{parameters specifying how the backend should handle things (most-likely parameters to \code{rhwatch} in RHIPE) - see \code{\link{rhipeControl}} and \code{\link{localDiskControl}}}
}
\value{
a 'ddo' or 'ddf' object
}
\description{
Filter a 'ddo' or 'ddf' object by selecting key-value pairs that satisfy a logical condition
}
\examples{
# Create a ddf using the iris data
bySpecies <- divide(iris, by = "Species")

# Filter using only the 'value' of the key/value pair
drFilter(bySpecies, function(v) mean(v$Sepal.Width) < 3)

# Filter using both the key and value
drFilter(bySpecies, function(k,v) k != "Species=virginica" & mean(v$Sepal.Width) < 3)
}
\author{
Ryan Hafen
}
\seealso{
\code{\link{drJoin}}, \code{\link{drLapply}}
}

