% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddo_ddf_methods.R
\name{removeData}
\alias{removeData}
\title{Remove Key-Value Pairs from a Data Connection}
\usage{
removeData(conn, keys)
}
\arguments{
\item{conn}{a kvConnection object}

\item{keys}{a list of keys indicating which k/v pairs to remove}
}
\description{
Remove key-value pairs from a data connection
}
\note{
This is generally not recommended for HDFS as it writes a new file each time it is called, and can result in more individual files than Hadoop likes to deal with.
}
\examples{
# connect to empty localDisk directory
conn <- localDiskConn(file.path(tempdir(), "irisSplit"), autoYes = TRUE)
# add some data
addData(conn, list(list("1", iris[1:10,])))
addData(conn, list(list("2", iris[11:90,])))
addData(conn, list(list("3", iris[91:110,])))
addData(conn, list(list("4", iris[111:150,])))
# represent it as a distributed data frame
irisDdf <- ddf(conn, update = TRUE)
irisDdf
# remove data for keys "1" and "2"
removeData(conn, list("1", "2"))
# look at result with updated attributes (reset = TRUE removes previous attrs)
irisDdf <- ddf(conn, reset = TRUE, update = TRUE)
irisDdf
}
\author{
Ryan Hafen
}
\seealso{
\code{\link{removeData}}, \code{\link{localDiskConn}}, \code{\link{hdfsConn}}
}

