% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-url.R
\name{import-url}
\alias{import-url}
\alias{import_url_ui}
\alias{import_url_server}
\title{Import data from a URL}
\usage{
import_url_ui(id, title = TRUE)

import_url_server(
  id,
  btn_show_data = TRUE,
  show_data_in = c("popup", "modal"),
  trigger_return = c("button", "change"),
  return_class = c("data.frame", "data.table", "tbl_df", "raw"),
  reset = reactive(NULL)
)
}
\arguments{
\item{id}{Module's ID.}

\item{title}{Module's title, if \code{TRUE} use the default title,
use \code{NULL} for no title or a \code{shiny.tag} for a custom one.}

\item{btn_show_data}{Display or not a button to display data in a modal window if import is successful.}

\item{show_data_in}{Where to display data: in a \code{"popup"} or in a \code{"modal"} window.}

\item{trigger_return}{When to update selected data:
\code{"button"} (when user click on button) or
\code{"change"} (each time user select a dataset in the list).}

\item{return_class}{Class of returned data: \code{data.frame}, \code{data.table}, \code{tbl_df} (tibble) or \code{raw}.}

\item{reset}{A \code{reactive} function that when triggered resets the data.}
}
\value{
\itemize{
\item UI: HTML tags that can be included in shiny's UI
\item Server: a \code{list} with three slots:
\itemize{
\item \strong{status}: a \code{reactive} function returning the status: \code{NULL}, \code{error} or \code{success}.
\item \strong{name}: a \code{reactive} function returning the name of the imported data as \code{character}.
\item \strong{data}: a \code{reactive} function returning the imported \code{data.frame}.
}
}
}
\description{
Let user paste link to a JSON then import the data.
}
\examples{

library(shiny)
library(datamods)

ui <- fluidPage(
  tags$h3("Import data from URL"),
  fluidRow(
    column(
      width = 4,
      import_url_ui("myid")
    ),
    column(
      width = 8,
      tags$b("Import status:"),
      verbatimTextOutput(outputId = "status"),
      tags$b("Name:"),
      verbatimTextOutput(outputId = "name"),
      tags$b("Data:"),
      verbatimTextOutput(outputId = "data")
    )
  )
)

server <- function(input, output, session) {

  imported <- import_url_server(
    "myid",
    btn_show_data = FALSE,
    return_class = "raw"
  )

  output$status <- renderPrint({
    imported$status()
  })
  output$name <- renderPrint({
    imported$name()
  })
  output$data <- renderPrint({
    imported$data()
  })

}

if (interactive())
  shinyApp(ui, server)
}
