% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{boreal2}
\alias{boreal2}
\title{Ubicación espacial de árboles en un bosque boreal (Finlandia).}
\format{
Las columnas son las siguientes:
\describe{
\item{id}{tree id}											
\item{x}{Posición cartesiana en el eje-X, en m.}
\item{y}{Posición cartesiana en el eje-Y, en m.}
\item{dap}{Diametro a la altura del pecho, en cm.}
\item{atot}{Altura total, en m.} 
\item{species}{Especie.}
 }
}
\source{
Datos fueron obtenidos desde los archivos disponibles en \doi{10.6084/m9.figshare.19698352.v1}.
}
\usage{
data(boreal2)
}
\description{
Ubicación espacial de árboles en una parcela de muestreo de 8.8ha establecida en
 un bosque adulto sub-artico ubicado en la reserva natural Varriostrict, en 
  el nor-este de Fennoscandia (67 44 N, 29 34 E), en Finlandia.  La parcela es rectangular (180 m × 500 m), pero
   por razones practicas, un porción menor rectangular (20 m × 100 m) se perdio en la esquina sur-este.
}
\examples{
data(boreal2)    
head(boreal2) 
tapply(boreal2$dap,boreal2$especie,mean)
library(lattice)
histogram(~dap|especie, data=boreal2)
}
\references{
Pouta P, Kulha N, Kuuluvainen T, Aakala T. 2022. Partitioning of Space Among Trees in
 an Old-Growth Spruce Forest in Subarctic Fennoscandia. Frontiers in Forests and Global Change 5: 817248. \doi{10.3389/ffgc.2022.817248}
}
\keyword{datasets}
