% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{carbohydrates}
\alias{carbohydrates}
\title{Carbohydrates concentrations in tissues of several tree species.}
\format{
Contains 16 variables, as follows:
\describe{
  \item{climate}{Climate of each location, mediterranean and temperate.}
  \item{site}{Name of Location of study (termmas:Termas de Chillan , antillanca:Antillanca area within Puyehue National Park,
              castillo:Cerro Castillo Natural Reserve, farellones:Farellones in Central Chile, 
              pyrenees: Sierra de Cutas area in Spanish Central Pyrenees,sierra:Sierra Nevada).}
\item{species}{name species of study (lenga: Nothofagus pumilio, frangel: Kageneckia angustifolia,
               uncinata: Pinus uncinata, sylvestris: Pinus sylvestris).}
\item{tissue}{Type of tissue, new developing twings, stem sapwood and branches.}
\item{season}{Meauserement season (spring or autumn).}
\item{elevation}{Type of elevation. "Treeline", intermediate named as "mid", and closed or
      montane forest named as "low".}
\item{tree}{Id for tree.}
\item{tree.site}{Id site for each location of study.}
\item{tss}{Value of concentrations soluble carbohydrate per mass unit.}
\item{st}{Value of concentrations starch per mass unit.}
\item{nsc}{Value of concentrations non structural carbohydrates per mass unit.}
\item{tss.nsc}{.}
\item{wd}{It might be 'wood density', but not sure.}
\item{tss.mv}{Value of concentrations soluble carbohydrate per volume unit.}
\item{st.mv}{Value of concentrations starch per volume unit.}
\item{nsc.mv}{Value of concentrations non structural carbohydrates per volume unit.}
 }
}
\source{
The data were obtained from the DRYAD repository at \doi{10.5061/dryad.ks97h}.
}
\usage{
data(carbohydrates)
}
\description{
Dataset contains 863 observations, about total soluble carbohydrate, starch, and non structural carbohydrates 
concentrations per mass unit and per volume unit, in three tissues in early summer and early autumn 6-8 adult trees
of different species at three elevations of altitudinal gradients sampled in four locations of Chile 
and Spain.
}
\examples{
data(carbohydrates)    
head(carbohydrates)
boxplot(nsc~species, data=carbohydrates) 
with(carbohydrates, tapply(tss, list("Elevation"=elevation.class, "Species"=species), mean))
}
\references{
Piper F, Vinegla B, Linares J, Camarero J, Cavieres L, Fajardo A. 2016. Mediterranean and temperate treelines are 
controlled by different environmental drivers. Journal Ecology. 104: 691-702.
}
\keyword{datasets}
