% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findcolumn.byname.R
\name{findColumn.byname}
\alias{findColumn.byname}
\title{A function that finds the position of a specific variable.}
\usage{
findColumn.byname(data = data, col.name = col.name)
}
\arguments{
\item{data}{a dataframe containing variables as columns}

\item{col.name}{is a string specifying the name of the variable}
}
\value{
The number representing the column position in the dataframe of the requested 
column-name. It can also be used for several names, thus, will return a vector of numbers.
}
\description{
This function finds the column-position of a specified column-name in an object (either a data frame or vector).
}
\note{
It can be used for a vector of specified column-names as well.
}
\examples{
data(deadForestCA)
df <- deadForestCA
names(df)
findColumn.byname(df, "Defz2")
findColumn.byname(df, c("Defnorm","mort.bin"))
  
}
\author{
Christian Salas-Eljatib
}
