% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{forestFire}
\alias{forestFire}
\title{Data of forest fire occurrence}
\format{
The data frame contains four variables as follows:
\describe{
\item{fire}{Presence of forest fire (1 yes, 0 no)}											
\item{xcoord}{Geographic coordinate x.utm}
\item{ycoord}{Geographic coordinate y.utm}
\item{aspect}{Exposure (degrees from north)}
\item{eleva}{Elevation (m)}
\item{slope}{Slope (degrees)}
\item{distr}{Distance to dirt roads}
\item{distcity}{Distance to cities}
\item{distriver}{Distance to paved roads}
\item{covera}{Land use classifications according to a polygon}
\item{coverb}{Land use classifications according to a polygon}
\item{tempe}{Minimum temperature of the coldest month}
\item{ppan}{Annual precipitation}
\item{ndii}{Normalized difference infrared index}
\item{nvdi}{Normalized difference vegetation index}
\item{tempe2}{Minimum temperature of the warmest month}
\item{ppan2}{Precipitation of the driest month}
\item{frec.fire}{Frequency of fires}
\item{perc.fire}{Percentage of fire frequency}
\item{fireClass}{Class for frecuency fire}
\item{asp.class}{Class of variable exposure}
\item{eleva.class}{Class of numerical variable elevation}
\item{slope.class}{Class of numerical variable slope}
\item{ndii.class}{Normalized difference infrared index class}
\item{nvdi.class}{Normalized difference vegetation index class}
 }
}
\source{
Data were compiled by Dr Adison Altamirano (Universidad de La Frontera, Temuco, Chile) from
the Chilean Forest Service (CONAF).
}
\usage{
data(forestFire)
}
\description{
Data of forest fire occurrence from Altamirano et al. (2013) as the population under study, 
containing 7210 total observations, with only 890 cases of fire occurrence
 and 6320 cases of non-occurrence. The binary variable (Y) is the occurrence of forest fire, 
 where Y equal to 1 denotes occurrence and Y equal to 0 otherwise.
}
\examples{
data(forestFire)    
head(forestFire) 
}
\references{
Altamirano A, Salas C, Yaitul V, Smith-Ramirez C, Avila A. 2013. Infuencia de la heterogeneidad 
del paisaje en la ocurrencia de incendios forestales en Chile Central. Revista de Geografia del Norte Grande, 55:157-170.
}
\keyword{datasets}
