% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MNode.R
\docType{class}
\name{MNode-class}
\alias{MNode-class}
\title{Provides R API to DataONE Member Node services.}
\description{
MNode provides functions that interact with a DataONE Member Node (MN). A MN 
is a repository that provides access for reading and writing data and metadata using the
DataONE MN service API.  The MN API includes functions for retrieving data and metadata based on its
unique persistent identifier (pid), as well as for creating, updating, and archiving these data and
metadata objects.
}
\details{
Methods that perform write operations (such as createObject and updateObject) on the MN generally 
require authentication. For MNs that have implemented the DataONE API version 2.0 and higher, these operations can utilize an 
authentication token to provide credentials for write operations in DataONE.
The authentication token is obtained from DataONE (see your account profile on https://search.dataone.org).
See the \code{vignette("dataone-overview")} for details.
Alternatively, the version 1.0 approach of using an X.509 certificate in a default location of the file 
system can also be used. This certificate provides authentication credentials from 
CILogon \url{https://cilogon.org/?skin=DataONE}.
}
\section{Slots}{

\describe{
\item{\code{endpoint}}{The url to access node services, which is the baseURL plus the version string}
}}

\section{Methods}{

\itemize{
 \item{\code{\link{MNode}}}{: Create a MNode object representing a DataONE Member Node repository.}
 \item{\code{\link{createObject}}}{: Create an object on a Member Node.}
 \item{\code{\link{getObject}}}{: Get the bytes associated with an object on the Member Node}
 \item{\code{\link{getCapabilities}}}{: Get the node capabilities description, and store the information in the MNode.}
 \item{\code{\link{generateIdentifier}}}{: Get a unique identifier that is generated by the Member Node repository and guaranteed to be unique.}
 \item{\code{\link{getPackage}}}{: Download a data package from a member node.}
 \item{\code{\link{updateObject}}}{: Update an object to a Member Node, by creating a new object that replaces an original.}
 \item{\code{\link{updateSystemMetadata}}}{: Update the system metadata associated with an object.}
}
}

\examples{
\dontrun{
library(dataone)
library(uuid)
library(digest)
cn <- CNode("STAGING")
mn <- getMNode(cn, "urn:node:mnStageUCSB2")
mnid <- mn@identifier
# Have Dataone create an identifier for you (requires authentication)
\dontrun{
newid <- generateIdentifier(mn, "UUID")
}
# Create an identifier manually
newid <- paste("urn:uuid:", UUIDgenerate(), sep="")
testdf <- data.frame(x=1:10,y=11:20)
csvfile <- paste(tempfile(), ".csv", sep="")
write.csv(testdf, csvfile, row.names=FALSE)
f <- "text/csv"
size <- file.info(csvfile)$size
sha256 <- digest(csvfile, algo="sha256", serialize=FALSE, file=TRUE)
sysmeta <- new("SystemMetadata", identifier=newid, formatId=f, size=size,
    checksum=sha256, originMemberNode=mnid, authoritativeMemberNode=mnid)
# Upload data to DataONE (requires authentication)
\dontrun{
response <- createObject(mn, newid, csvfile, sysmeta)
}
}
}
\seealso{
\code{\link{dataone}}{ package description.}
}
