% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CNode.R
\name{getFormat}
\alias{getFormat}
\alias{getFormat,CNode-method}
\title{Get information for a single DataONE object format}
\usage{
getFormat(x, ...)

\S4method{getFormat}{CNode}(x, formatId)
}
\arguments{
\item{x}{A CNode object instance}

\item{...}{(Not yet used)}

\item{formatId}{The formatId to retrieve.}
}
\value{
A dataframe of all object formats registered in the DataONE Object Format Vocabulary.
}
\description{
Get information for a single DataONE object format
}
\examples{
\dontrun{
library(dataone)
cn <- CNode()
fmt <- getFormat(cn, "eml://ecoinformatics.org/eml-2.1.0")
cat(sprintf("format name: \%s\n", fmt$name))
cat(sprintf("format type: \%s\n", fmt$type))
cat(sprintf("format Id: \%s\n", fmt$id))
}
}
\seealso{
\code{\link[=CNode-class]{CNode}}{ class description.}
}
