% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataPackage.R
\docType{class}
\name{DataPackage-class}
\alias{DataPackage-class}
\title{A class representing a data package, which can contain data objects}
\description{
The DataPackage class provides methods for added and extracting
data objects from a datapackage. The contents of a package
can be determined and the package can be prepared for transport before being
uploaded to a data repository or archived.
}
\section{Slots}{

\describe{
\item{\code{relations}}{A hash containing provenance relationships of package objects}

\item{\code{objects}}{A hash containing identifiers for data object in the DataPackage}

\item{\code{sysmeta}}{A SystemMetadata class instance describing the package}
}}
\section{Methods}{

\itemize{
 \item{\code{\link[=DataPackage-initialize]{initialize}}}{: Initialize a DataPackage object}
 \item{\code{\link{getData}}}{: Get the data content of a specified data object}
 \item{\code{\link{getSize}}}{: Get the Count of Objects in the Package}
 \item{\code{\link{getIdentifiers}}}{: Get the Identifiers of Package Members}
 \item{\code{\link{addData}}}{: Add a DataObject to the DataPackage}
 \item{\code{\link{insertRelationship}}}{: Record relationships of objects in a DataPackage}
 \item{\code{\link{recordDerivation}}}{: Record derivation relationships between objects in a DataPackage}
 \item{\code{\link{getRelationships}}}{: Retrieve relationships of package objects}
 \item{\code{\link{containsId}}}{: Returns true if the specified object is a member of the package}
 \item{\code{\link{removeMember}}}{: Remove the Specified Member from the Package}
 \item{\code{\link{getMember}}}{: Return the Package Member by Identifier}
 \item{\code{\link{serializePackage}}}{: Create an OAI-ORE resource map from the package}
 \item{\code{\link{serializeToBagIt}}}{: Serialize A DataPackage into a BagIt Archive File}
}
}
\seealso{
\code{\link{datapack}}
}

