% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/com_unit_missingness.R
\name{com_unit_missingness}
\alias{com_unit_missingness}
\title{Counts all individuals with no measurements at all}
\usage{
com_unit_missingness(
  study_data,
  meta_data,
  id_vars = NULL,
  strata_vars = NULL,
  label_col
)
}
\arguments{
\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{id_vars}{\link{variable list} optional, a (vectorized) call of ID-variables
that should not be
considered in the calculation of unit-
missingness}

\item{strata_vars}{\link{variable} optional, a string or integer variable used for
stratification}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}
}
\value{
A list with:
\itemize{
\item \code{FlaggedStudyData}: \link{data.frame} with id-only-rows flagged in a column
\code{Unit_missing}
\item \code{SummaryData}: \link{data.frame} with numbers and percentages of unit
missingness
}
}
\description{
This implementation examines a crude version of unit missingness or
unit-nonresponse (Kalton and Kasprzyk 1986), i.e. if all measurement
variables in the study data are missing for an observation it has unit
missingness.

The function can be applied on stratified data. In this case strata_vars must
be specified.
}
\details{
This implementations calculates a crude rate of unit-missingness. This type
of missingness may have several causes and is an important research outcome.
For example, unit-nonresponse may be selective regarding the targeted study
population or technical reasons such as record-linkage may cause
unit-missingness.

It has to be discriminated form segment and item missingness, since different
causes and mechanisms may be the reason for unit-missingness.
\subsection{Hint}{

This function does not support a \code{resp_vars} argument but \code{id_vars}, which
have a roughly inverse logic behind: id_vars with values do not prevent a row
from being considered missing, because an ID is the only hint for a unit that
elsewise would not occur in the data at all.

List function.
}
}
\seealso{
\href{https://dataquality.ship-med.uni-greifswald.de/VIN_com_impl_unit_missingness.html}{Online Documentation}
}
