% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_all_intro_vars_for_rv.R
\name{util_all_intro_vars_for_rv}
\alias{util_all_intro_vars_for_rv}
\title{Get all \code{PART_VARS} for a response variable (from item-level metadata)}
\usage{
util_all_intro_vars_for_rv(
  rv,
  study_data,
  meta_data,
  label_col = LABEL,
  expected_observations = c("HIERARCHY", "ALL", "SEGMENT")
)
}
\arguments{
\item{rv}{\link{character} the response variable's name}

\item{study_data}{\link{study_data}}

\item{meta_data}{\link{meta_data}}

\item{label_col}{\link{character} the metadata attribute to map \code{meta_data} on
\code{study_data} based on \code{colnames(study_data)}}

\item{expected_observations}{\link{enum} HIERARCHY | ALL | SEGMENT. How should
\code{PART_VARS} be handled:
- \code{ALL}: Ignore, all observations are
expected
- \code{SEGMENT}: if \code{PART_VAR} is 1, an
observation is expected
- \code{HIERARCHY}: the default, if the
\code{PART_VAR} is 1 for this variable and
also for all \code{PART_VARS} of \code{PART_VARS}
up in the hierarchy, an observation is
expected.}
}
\value{
\link{character} all \code{PART_VARS} for \code{rv} from item level metadata.
For \code{expected_observations = HIERARCHY}, the more general \code{PART_VARS}
(i.e., up, in the hierarchy) are more left in the vector, e.g.:
\verb{PART_STUDY, PART_PHYSICAL_EXAMINATIONS, PART_BLOODPRESSURE}
}
\description{
Get all \code{PART_VARS} for a response variable (from item-level metadata)
}
