% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_check_meta_data_dataframe.R
\name{prep_check_meta_data_dataframe}
\alias{prep_check_meta_data_dataframe}
\title{Verify and normalize metadata on data frame level}
\usage{
prep_check_meta_data_dataframe(meta_data_dataframe = "dataframe_level")
}
\arguments{
\item{meta_data_dataframe}{\link{data.frame} data frame or path/url of a metadata
sheet for the data frame level}
}
\value{
standardized metadata sheet as data frame
}
\description{
if possible, mismatching data types are converted (\code{"true"} becomes \code{TRUE})
}
\details{
missing columns are added, filled with \code{NA}, if this is valid, i.e., n.a.
for \code{DF_NAME} as the key column
}
\examples{
\dontrun{
mds <- prep_check_meta_data_dataframe("ship_meta_dataframe|dataframe_level") # also converts
print(mds)
prep_check_meta_data_dataframe(mds)
mds1 <- mds
mds1$DF_RECORD_COUNT <- NULL
print(prep_check_meta_data_dataframe(mds1)) # fixes the missing column by NAs
mds1 <- mds
mds1$DF_UNIQUE_ROWS[[2]] <- "xxx" # not convertible
# print(prep_check_meta_data_dataframe(mds1)) # fail
mds1 <- mds
mds1$DF_UNIQUE_ID[[2]] <- 12 # not yet supported
# print(prep_check_meta_data_dataframe(mds1)) # fail
}
}
