% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_remove_na_records.R
\name{util_remove_na_records}
\alias{util_remove_na_records}
\title{remove all records, that have at least one \code{NA} in any of the given variables}
\usage{
util_remove_na_records(study_data, vars = colnames(study_data))
}
\arguments{
\item{study_data}{the study data frame}

\item{vars}{the variables being checked for \code{NA}s}
}
\value{
modified study_data data frame
}
\description{
remove all records, that have at least one \code{NA} in any of the given variables
}
\examples{
\dontrun{
dta <- iris
dim(util_remove_na_records(dta))
dta$Species[4:6] <- NA
dim(util_remove_na_records(dta))
dim(util_remove_na_records(dta, c("Sepal.Length", "Petal.Length")))
}
}
