% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_limit_deviations.R
\name{con_limit_deviations}
\alias{con_limit_deviations}
\title{Detects variable values exceeding limits defined in metadata}
\usage{
con_limit_deviations(
  resp_vars = NULL,
  label_col,
  study_data,
  meta_data,
  limits = NULL,
  flip_mode = "noflip",
  return_flagged_study_data = FALSE
)
}
\arguments{
\item{resp_vars}{\link{variable list} the name of the measurement variables}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{limits}{\link{enum} HARD_LIMITS | SOFT_LIMITS | DETECTION_LIMITS. what
limits from metadata to check for}

\item{flip_mode}{\link{enum} default | flip | noflip | auto. Should the plot be
in default orientation, flipped, not flipped or
auto-flipped. Not all options are always supported.
In general, this con be controlled by
setting the \code{roptions(dataquieR.flip_mode = ...)}. If
called from \code{dq_report}, you can also pass
\code{flip_mode} to all function calls or set them
specifically using \code{specific_args}.}

\item{return_flagged_study_data}{\link{logical} return \code{FlaggedStudyData} in the
result}
}
\value{
a list with:
\itemize{
\item \code{FlaggedStudyData} \link{data.frame} related to the study data by a 1:1
relationship, i.e. for each observation is
checked whether the value is below or above
the limits. Optional, see
\code{return_flagged_study_data}.
\item \code{SummaryTable} \link{data.frame} summarizes limit deviations for each
variable.
\item \code{SummaryPlotList} \link{list} of \link{ggplot}s The plots for each variable are
either a histogram (continuous) or a
barplot (discrete).
\item \code{ReportSummaryTable}: heatmap-like data frame about limit violations
}
}
\description{
Inadmissible numerical values can be of type integer or float. This
implementation requires the definition of intervals in the metadata to
examine the admissibility of numerical study data.

This helps identify inadmissible measurements according to
hard limits (for multiple variables).

\link{Indicator}
}
\details{
\subsection{Algorithm of this implementation:}{
\itemize{
\item Remove missing codes from the study data (if defined in the metadata)
\item Interpretation of variable specific intervals as supplied in the metadata.
\item Identification of measurements outside defined limits. Therefore two
output data frames are generated:
\itemize{
\item on the level of observation to flag each deviation, and
\item a summary table for each variable.
}
\item A list of plots is generated for each variable examined for limit
deviations. The histogram-like plots indicate respective limits as well
as deviations.
\item Values exceeding limits are removed in a data frame of modified study data
}
}
}
\seealso{
\itemize{
\item \href{https://dataquality.qihs.uni-greifswald.de/VIN_con_impl_limit_deviations.html}{Online Documentation}
}
}
