% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_load_folder_with_metadata.R
\name{prep_load_folder_with_metadata}
\alias{prep_load_folder_with_metadata}
\title{Pre-load a folder with named (usually more than) one table(s)}
\usage{
prep_load_folder_with_metadata(folder, keep_types = FALSE, ...)
}
\arguments{
\item{folder}{the folder name to load.}

\item{keep_types}{\link{logical} keep types as possibly defined in the file.
set \code{TRUE} for study data.}

\item{...}{arguments passed to []}
}
\value{
\verb{invisible(the cache environment)}
}
\description{
These can thereafter be referred to by their names only. Such files are,
e.g., spreadsheet-workbooks or \code{RData}-files.
}
\details{
Note, that this function in contrast to \link{prep_get_data_frame} does neither
support selecting specific sheets/columns from a file.
}
\examples{
\dontrun{
folder_name <-
  system.file("extdata", package = "dataquieR")
prep_load_folder_with_metadata(folder_name)
prep_get_data_frame(
  "dataframe_level") # dataframe_level is a sheet in the file
}
}
\seealso{
\link{prep_add_data_frames}

\link{prep_get_data_frame}

Other data-frame-cache: 
\code{\link{prep_add_data_frames}()},
\code{\link{prep_get_data_frame}()},
\code{\link{prep_list_dataframes}()},
\code{\link{prep_load_workbook_like_file}()},
\code{\link{prep_purge_data_frame_cache}()}
}
\concept{data-frame-cache}
