% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int_unexp_records_set.R
\name{int_unexp_records_set}
\alias{int_unexp_records_set}
\title{Check for unexpected data record set}
\usage{
int_unexp_records_set(
  level = c("dataframe", "segment"),
  study_data,
  item_level = "item_level",
  label_col,
  meta_data = item_level,
  meta_data_v2,
  ...
)
}
\arguments{
\item{level}{\link{character} a character vector indicating whether the assessment should be conducted at the study level (level = "dataframe") or at the segment level (level = "segment").}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{item_level}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{meta_data}{\link{data.frame} old name for \code{item_level}}

\item{meta_data_v2}{\link{character} path to workbook like metadata file, see
\code{\link{prep_load_workbook_like_file}} for details.
\strong{ALL LOADED DATAFRAMES WILL BE PURGED},
using \code{\link{prep_purge_data_frame_cache}},
if you specify \code{meta_data_v2}.}

\item{...}{Depending on \code{level}, passed to either
\link{util_int_unexp_records_set_segment} or
\link{util_int_unexp_records_set_dataframe}}
}
\value{
a \link{list}. Depending on \code{level}, see
\link{util_int_unexp_records_set_segment} or
\link{util_int_unexp_records_set_dataframe} for a description of the outputs.
}
\description{
This function tests that the identifiers match a provided record set. It is possible to
check for unexpected data record sets by study segments or to consider only selected
segments.

\link{Indicator}
}
