% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_int_duplicate_ids_segment.R
\name{util_int_duplicate_ids_segment}
\alias{util_int_duplicate_ids_segment}
\title{Check for duplicated IDs}
\usage{
util_int_duplicate_ids_segment(
  level = c("segment"),
  id_vars_list,
  study_segment,
  repetitions,
  study_data,
  meta_data,
  meta_data_segment = "segment_level",
  segment_level
)
}
\arguments{
\item{level}{\link{character} a character vector indicating whether the assessment should be conducted at the study level (level = "dataframe") or at the segment level (level = "segment").}

\item{id_vars_list}{\link{list} id variable names for each segment or data frame}

\item{study_segment}{\link{vector} the segments or data frame names being assessed}

\item{repetitions}{\link{vector} an integer vector indicating the number of allowed repetitions in the id_vars. Currently, no repetitions are supported.}

\item{study_data}{\link{data.frame} the data frame that contains the measurements, mandatory.}

\item{meta_data}{\link{data.frame} the data frame that contains metadata attributes of the study data, mandatory.}

\item{meta_data_segment}{\link{data.frame} -- optional: Segment level metadata}

\item{segment_level}{\link{data.frame} alias for \code{meta_data_segment}}
}
\value{
a \link{list} with
\itemize{
\item \code{SegmentData}: data frame with the results of the quality check for duplicated identifiers
\item \code{SegmentTable}: data frame with selected duplicated identifiers check results, used for the data quality report.
\item \code{Other}: named list with inner lists of unique cases containing each the
row indices of duplicated identifiers separated by "|" , if any.
outer names are names of the segments.
Use \code{\link[=prep_get_study_data_segment]{prep_get_study_data_segment()}} to get the data frame the
indices refer to.
}
}
\description{
This function tests for duplicates entries in identifiers. It is possible to
check duplicated identifiers by study segments or to consider only selected
segments.
}
\seealso{
Other integrity_indicator_functions: 
\code{\link{util_int_duplicate_content_dataframe}()},
\code{\link{util_int_duplicate_content_segment}()},
\code{\link{util_int_duplicate_ids_dataframe}()},
\code{\link{util_int_unexp_records_set_dataframe}()},
\code{\link{util_int_unexp_records_set_segment}()}
}
\concept{integrity_indicator}
\concept{integrity_indicator_functions}
\keyword{internal}
