% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decade.R
\name{plot_subdaily}
\alias{plot_subdaily}
\title{Plot sub-daily data points}
\usage{
plot_subdaily(subdailydata, year = NA, outfile, fixed = TRUE, units = NA, ...)
}
\arguments{
\item{subdailydata}{A character string giving the path of the input file, or
a 7-column matrix with following columns: variable code, year, month, day,  
hour, minute, value.}

\item{year}{Integer vector giving the year(s) to plot. If not specified (NA), 
all available years will be plotted. One pdf per year will be created.}

\item{outfile}{Character string giving the path of the output pdf file. If
\code{year} has more than one element or is NA, then this is a root to the 
filenames to which the year will be added ('root.year.pdf').}

\item{fixed}{If TRUE (default), use the same y axis for all months. If FALSE,
the axis limits are set based on the data range of each month.}

\item{units}{Character string giving the units (will be printed in the y-axis). 
If \code{subdailydata} is a path to a file, then the units are read from the 
SEF header.}

\item{...}{Graphical parameters passed to the function \code{\link{plot}},
such as \code{cex}, \code{lwd}, \code{pch}, \code{col}, etc.
(see \code{\link{par}}).}
}
\description{
Plot sub-daily data points divided by month.
}
\details{
The input file must follow the C3S Station Exchange Format (SEF).

Creates one pdf for each year plotted.
}
\examples{
plot_subdaily(Bern$p, year = 1803:1804, outfile = paste0(tempdir(),"/test"))

}
\references{
Hunziker et al., 2017: Identifying, attributing, and overcoming common data quality 
issues of manned station observations. Int. J. Climatol, 37: 4131-4145.

Hunziker et al., 2018: Effects of undetected data quality issues on climatological
analyses. Clim. Past, 14: 1-20.
}
\author{
Stefan Hunziker, Yuri Brugnara
}
