#' Sub-daily meteorological observations for Bern
#' 
#' Observations of pressure and temperature for the city of Bern (Switzerland)
#' for the period 1800-1827.
#' 
#' @format A list of data frames (one data frame per variable).
#' The format of the data frames is that required by the QC functions.
#' @source Institute of Geography - University of Bern
"Bern"

#' Daily and sub-daily meteorological observations for Rosario de Santa Fe (Argentina)
#' 
#' Observations of minimum and maximum temperature, wind direction, cloud cover,
#' pressure, precipitation, air temperature, wet bulb temperature, relative humidity,
#' dew point, and wind speed for the city of Rosario de Santa Fe (Argentina) for the 
#' period 1886-1900.
#' 
#' @format A list of data frames (one data frame per variable).
#' The format of the data frames is that required by the QC functions.
#' @source ACRE
"Rosario"

#' Metadata for the stations of Bern and Rosario de Santa Fe
#' 
#' @format A list of data frames (one data frame per variable)
#' @source Institute of Geography - University of Bern
"Meta"

#' Table of available qc tests
#' 
#' @format Data frame
"Tests"

#' Table of supported variable codes
#' 
#' @format Data frame
"Variables"

utils::globalVariables(c("Tests", "Variables", "ind", "value", "variable"))