% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelRecommendations.R
\name{GetRecommendedModel}
\alias{GetRecommendedModel}
\title{Retrieve the model object that DataRobot recommends for your project.}
\usage{
GetRecommendedModel(project, type = RecommendedModelType$FastAccurate)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{type}{character. The type of recommendation to retrieve. See
\code{RecommendedModelType} for available options. Defaults to
\code{RecommendedModelType$FastAccurate}.}
}
\value{
The model object corresponding with that recommendation
}
\description{
Retrieve the model object that DataRobot recommends for your project.
}
\examples{
\dontrun{
 projectId <- "5984b4d7100d2b31c1166529"
 GetRecommendedModel(projectId)
}
}
