% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionExplanations.R
\name{GetPredictionExplanations}
\alias{GetPredictionExplanations}
\title{Get prediction explanations}
\usage{
GetPredictionExplanations(model, dataset, maxExplanations = NULL,
  thresholdLow = NULL, thresholdHigh = NULL, batchSize = NULL,
  maxWait = 600, excludeAdjustedPredictions = TRUE)
}
\arguments{
\item{model}{An S3 object of class dataRobotModel like that returned by
the function GetModel, or each element of the list returned by
the function ListModels.}

\item{dataset}{object. Either (1) the prediction dataset object of class
\code{dataRobotPredictionDataset}, (2) a data.frame containing the prediction data,
(3) the datasetID of the prediction dataset, (4) a file path to the data, or
(5) a URL to the data. References the dataset of predictions used to get prediction
explanations for.}

\item{maxExplanations}{integer. Optional. The maximum number of prediction explanations to supply
per row of the dataset, default: 3.}

\item{thresholdLow}{numeric. Optional. The lower threshold, below which a prediction must
score in order for prediction explanations to be computed for a row in the dataset. If
neither \code{threshold_high} nor \code{threshold_low} is specified, prediction
explanations will be computed for all rows.}

\item{thresholdHigh}{numeric. Optional. The high threshold, above which a prediction must score
in order for prediction explanations to be computed. If neither \code{threshold_high} nor
\code{threshold_low} is specified, prediction explanations will be computed for all rows.}

\item{batchSize}{integer. Optional. Maximum number of prediction explanations rows to
retrieve per request}

\item{maxWait}{integer. The maximum time (in seconds) to wait for the model job to complete.}

\item{excludeAdjustedPredictions}{logical. Optional. Set to FALSE to include adjusted
predictions, which are predictions adjusted by an exposure column. This is only relevant for
projects that use an exposure column.}
}
\value{
data frame with following colums:
\itemize{
  \item rowId integer. Row id from prediction dataset.
  \item prediction numeric. The output of the model for this row (numric prediction for
    regression problem, predicted class for classification problem).
  \item class1Label character. Label of class 0. Available only for classification
    problem.
  \item class1Probability numeric. Predicted probability of class 0. Available only for
    classification problem.
  \item class2Label character. Label of class 1. Available only for classification
  \item class2Probability numeric. Predicted probability of class 1. Available only for
    classification problem.
  \item explanation1FeatureName character. The name of the feature contributing to the
    prediction.
  \item explanation1FeatureValue character. the value the feature took on for this row.
  \item explanation1QualitativeStrength numeric. How strongly the feature affected the prediction.
  \item explanation1Strength character. A human-readable description of how strongly the
    feature affected the prediction (e.g. '+++', '--', '+').
  \item explanation1Label character. Describes what output was driven by this prediction explanation.
  For regression projects, it is the name of the target feature.  For classification projects,
  it is theclass whose probability increasing would correspond to a positive strength of this.
  \item explanationNFeatureName character. The name of the feature contributing to the
    prediction.
  \item explanationNFeatureValue character. The value the feature took on for this row.
  \item explanationNQualitativeStrength numeric. How strongly the feature affected the prediction.
  \item explanationNStrength character. A human-readable description of how strongly the
    feature affected the prediction (e.g. '+++', '--', '+').
  \item explanationNLabel character. Describes what output was driven by this prediction explanation.
  For regression projects, it is the name of the target feature.  For classification projects,
  it is theclass whose probability increasing would correspond to a positive strength of this.
  \item explanationNFeatureName. Character string the name of the feature contributing to the
    prediction.
  }
}
\description{
A streamlined workflow to both generate and retrieve prediction explanations for a model.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  datasets <- ListPredictionDatasets(projectId)
  dataset <- datasets[[1]]
  model <- GetModel(projectId, modelId)
  GetPredictionExplanations(model, dataset)
}
}
