% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TransferableModels.R
\name{RequestTransferableModel}
\alias{RequestTransferableModel}
\title{Request generation of an transferable model file for use in an on-premise DataRobot standalone
prediction environment.
This function can only be used if model export is enabled, and will only be useful
if you have an on-premise environment in which to import it.
This function does not download the exported file. Use DownloadTransferableModel for that.}
\usage{
RequestTransferableModel(project, modelId)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{modelId}{numeric. Unique alphanumeric identifier for the model of interest.}
}
\value{
jobId
}
\description{
Request generation of an transferable model file for use in an on-premise DataRobot standalone
prediction environment.
This function can only be used if model export is enabled, and will only be useful
if you have an on-premise environment in which to import it.
This function does not download the exported file. Use DownloadTransferableModel for that.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  jobId <- RequestTransferrrableModel(projectId, modelId)
  WaitForJobToComplete(projectId, jobId)
  file <- file.path(tempdir(), "model.drmodel")
  DownloadTransferableModel(projectObject, modelId, file)
}
}
