% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionExplanations.R
\name{ListPredictionExplanationsMetadata}
\alias{ListPredictionExplanationsMetadata}
\title{Retrieve metadata for prediction explanations in specified project}
\usage{
ListPredictionExplanationsMetadata(
  project,
  modelId = NULL,
  limit = NULL,
  offset = NULL
)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{modelId}{character. Optional. If specified, only prediction explanations computed
for this model will be returned.}

\item{limit}{integer. Optional. At most this many results are returned, default: no limit}

\item{offset}{integer. This many results will be skipped, default: 0}
}
\value{
List of metadata for all prediction explanations in the project.
  Each element of list is metadata for one prediction explanations
  (for format see \code{GetPredictionExplanationsMetadata}).
}
\description{
Retrieve metadata for prediction explanations in specified project
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  ListPredictionExplanationsMetadata(projectId)
}
}
