% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TransferableModels.R
\name{RequestTransferableModel}
\alias{RequestTransferableModel}
\title{Request creation of a transferable model}
\usage{
RequestTransferableModel(project, modelId, predictionIntervalSize = NULL)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{modelId}{numeric. Unique alphanumeric identifier for the model of interest.}

\item{predictionIntervalSize}{integer. Optional. Added in 2.19. For supervised
time series projects, this is the desired prediction interval size for the
exported model. A prediction interval is the range of values DataRobot expects
actual values of the target to fall within 0 to 100 (inclusive).}
}
\value{
jobId
}
\description{
Requests generation of an transferable model file for use in an on-premise
DataRobot standalone prediction environment. This function can only be used
if model export is enabled, and will only be useful if you have an on-premise
environment in which to import it.
}
\details{
This function does not download the exported file. Use
\code{DownloadTransferableModel} for that.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  jobId <- RequestTransferableModel(projectId,
                                    modelId,
                                    50)
  WaitForJobToComplete(projectId, jobId)
  file <- file.path(tempdir(), "model.drmodel")
  DownloadTransferableModel(projectObject, modelId, file)
}
}
\seealso{
Other Transferable Model functions: 
\code{\link{DeleteTransferableModel}()},
\code{\link{DownloadTransferableModel}()},
\code{\link{GetTransferableModel}()},
\code{\link{ListTransferableModels}()},
\code{\link{UpdateTransferableModel}()},
\code{\link{UploadTransferableModel}()}
}
\concept{Transferable Model functions}
