% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deployment.R
\name{UpdateDeploymentDriftTrackingSettings}
\alias{UpdateDeploymentDriftTrackingSettings}
\title{Update drift tracking settings for a deployment.}
\usage{
UpdateDeploymentDriftTrackingSettings(
  deploymentId,
  targetDriftEnabled = NULL,
  featureDriftEnabled = NULL,
  maxWait = 600
)
}
\arguments{
\item{deploymentId}{character. The ID of the deployment.}

\item{targetDriftEnabled}{logical. Optional. Set to TRUE to enable target drift. Set to
FALSE to disable.}

\item{featureDriftEnabled}{logical. Optional. Set to TRUE to enable feature drift. Set to
FALSE to disable.}

\item{maxWait}{integer. How long to wait (in seconds) for the computation to complete
before returning a timeout error? (Default 600 seconds)}
}
\value{
A list with the following information on drift tracking:
\itemize{
   \item associationId
   \item predictionIntervals list. A list with two keys:
     \itemize{
        \item enabled. `TRUE` if prediction intervals are enabled and `FALSE` otherwise.
        \item percentiles list. A list of percentiles, if prediction intervals are enabled.
     }
   \item targetDrift list. A list with one key, `enabled`, which is `TRUE` if target
     drift is enabled, and `FALSE` otherwise.
   \item featureDrift list. A list with one key, `enabled`, which is `TRUE` if feature
     drift is enabled, and `FALSE` otherwise.
}
}
\description{
Update drift tracking settings for a deployment.
}
\examples{
\dontrun{
  deploymentId <- "5e319d2e422fbd6b58a5edad"
  UpdateDeploymentDriftTrackingSettings(deploymentId, targetDriftEnabled = TRUE)
}
}
