% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Blueprints.R
\name{BlueprintChartToGraphviz}
\alias{BlueprintChartToGraphviz}
\title{Convert a blueprint chart into graphviz DOT format}
\usage{
BlueprintChartToGraphviz(blueprintChart)
}
\arguments{
\item{blueprintChart}{list. The list returned by GetBlueprintChart function.}
}
\value{
Character string representation of chart in graphviz DOT language
}
\description{
Convert a blueprint chart into graphviz DOT format
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  model <- GetModelObject(projectId, modelId)
  blueprintId <- model$blueprintId
  blueprintChart <- GetBlueprintChart(projectId, blueprintId)
  BlueprintChartToGraphviz(blueprintChart)
}
}
