% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asDataFrame.R
\name{as.data.frame}
\alias{as.data.frame}
\alias{as.data.frame.listOfBlueprints}
\alias{as.data.frame.listOfFeaturelists}
\alias{as.data.frame.listOfModels}
\alias{as.data.frame.projectSummaryList}
\alias{as.data.frame.listOfDataRobotPredictionDatasets}
\title{DataRobot S3 object methods for R's generic as.data.frame function}
\usage{
\method{as.data.frame}{listOfBlueprints}(x, row.names = NULL,
  optional = FALSE, ...)

\method{as.data.frame}{listOfFeaturelists}(x, row.names = NULL,
  optional = FALSE, ...)

\method{as.data.frame}{listOfModels}(x, row.names = NULL, optional = FALSE,
  simple = TRUE, ...)

\method{as.data.frame}{projectSummaryList}(x, row.names = NULL,
  optional = FALSE, simple = TRUE, ...)

\method{as.data.frame}{listOfDataRobotPredictionDatasets}(x, row.names = NULL,
  optional = FALSE, ...)
}
\arguments{
\item{x}{S3 object to be converted into a dataframe.}

\item{row.names}{character. Optional. Row names for the dataframe returned by
the method.}

\item{optional}{logical. Optional. If TRUE, setting row
names and converting column names to syntactic names: see help for
\code{make.names} function.}

\item{\dots}{list. Additional optional parameters to be passed to the
generic as.data.frame function (not used at present).}

\item{simple}{logical. Optional. if TRUE (the default), a
simplified dataframe is returned for objects of class listOfModels
or projectSummaryList.}
}
\value{
A dataframe containing some or all of the data from the
  original S3 object; see Details.
}
\description{
These functions extend R's generic as.data.frame function to the
DataRobot S3 object classes listOfBlueprints, listOfFeaturelists,
listOfModels, and projectSummaryList.
}
\details{
All of the DataRobot S3 `listOf' class objects have relatively
complex structures and are often easier to work with as dataframes.
The methods described here extend R's generic as.data.frame function
to convert objects of these classes to convenient dataframes.  For
objects of class listOfBlueprints and listOfFeaturelists or objects
of class listOfModels and projectSummaryList with simple = FALSE,
the dataframes contain all information from the original S3 object.
The default value simple = TRUE provides simpler dataframes for
objects of class listOfModels and projectSummaryList.
}
