% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelDeployment.R
\name{ListModelDeployments}
\alias{ListModelDeployments}
\title{Retrieve information about all model deployments throughout your projects.}
\usage{
ListModelDeployments(limit = NULL, offset = NULL, query = NULL,
  orderBy = NULL, status = NULL)
}
\arguments{
\item{limit}{integer. At most this many results are returned. Defaults to no limit.}

\item{offset}{integer. This many results will be skipped. Defaults to 0.}

\item{query}{character. Filter the model deployments by matching labels and descriptions
with the specified string. Partial matches are included, too. Matches are case insensitive.}

\item{orderBy}{character. How the model deployments are ordered. Supported attributes for
ordering: label, exportTarget, status, type. Prefix attribute name with dash to sort in
descending order, e.g., \code{orderBy = "-label"}. Only one field can be selected.}

\item{status}{character. Filter the list of deployments by status. Must be one of:
"active", "inactive", "archived". Valid statuses can be seen in \code{ModelDeploymentStatus}.}
}
\value{
data.frame containing information about each model deployment. See
  \code{GetModelDeployment} for details.
}
\description{
Retrieve information about all model deployments throughout your projects.
}
\examples{
\dontrun{
 ListModelDeployments()
}
}
