% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StartAutopilot.R
\name{StartNewAutoPilot}
\alias{StartNewAutoPilot}
\title{Starts autopilot on provided featurelist.
Only one autopilot can be running at the time.
That's why any ongoing autopilot on different featurelist will
be halted - modelling jobs in queue would not
be affected but new jobs would not be added to queue by
halted autopilot.}
\usage{
StartNewAutoPilot(project, featurelistId, mode = AutopilotMode$FullAuto)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{featurelistId}{numeric. Specifies which feature list to use.}

\item{mode}{character. The desired autopilot mode. Currently only AutopilotMode$FullAuto
is supported.}
}
\description{
There is an error if autopilot is currently running on or has already
finished running on the provided featurelist and also if project's target was not selected
(via SetTarget).
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  featureList <- CreateFeaturelist(projectId, "myFeaturelist", c("feature1", "feature2"))
  featurelistId <- featureList$featurelistId
  StartNewAutoPilot(projectId, featurelistId)
}
}
