% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe.R
\name{describe}
\alias{describe}
\title{Describe a dataset in N-Triples format}
\usage{
describe(x, con)
}
\arguments{
\item{x}{A \code{dataset_df} object.}

\item{con}{A connection or a character string path (e.g. from \code{tempfile()}).}
}
\value{
Writes N-Triples to \code{con} and invisibly returns \code{x}.
}
\description{
Writes provenance and Dublin Core metadata of a dataset to a
file or connection in N-Triples format.
}
\examples{
test_ds <- dataset_df(
  rowid = defined(c("eg:1", "eg:2"),
    namespace = "http://example.com/dataset#"
  ),
  geo = defined(
    gdp$geo[1:2],
    label = "Country",
    concept = "http://example.com/prop/geo",
    namespace = "https://eionet.europa.eu/geo/$1"
  ),
  dataset_bibentry = dublincore(
    title = "Example Dataset",
    creator = person("John", "Doe")
  )
)

# returns invisibly the contents of the text file serialisation:
testdescription <- describe(test_ds, con = tempfile())
testdescription
}
