% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/whos.R
\name{whos.options}
\alias{whos.exclude}
\alias{whos.include}
\alias{whos.options}
\title{Set default behavior of the whos function}
\usage{
whos.options(exclude, report.S4.size)

whos.exclude(x = NULL, pattern, envir = parent.frame())

whos.include(x = NULL, pattern, envir = parent.frame())
}
\arguments{
\item{exclude}{Objects to exclude from view. Can be a character vector of
names, or an environment, but not any regular expressions so far.}

\item{report.S4.size}{Calculating the size of S4 objects with
\code{\link{object.size}} can take an annoyingly long time (seconds), set
this option to \code{FALSE} to skip it and get quicker execution.}

\item{x}{A character vector of object names to exclude or include.}

\item{pattern}{\link[=regex]{Regular expression pattern} to match object
names against, e.g. \code{pattern="^my\\..*"} will exclude or include
\code{"my.vector"} and \code{"my.matrix"} but not \code{"mysql.con"}.}

\item{envir}{Environment to search in.}
}
\value{
Nothing. The values are stored as global options.
}
\description{
Set default behavior of the whos function
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}

