% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_extract.R
\name{data_extract}
\alias{data_extract}
\alias{extract}
\title{Extract a single column or element from an object}
\usage{
data_extract(data, select, name = NULL, ...)

extract(data, select, name = NULL, ...)
}
\arguments{
\item{data}{The object to subset. Methods are currently available for data frames
and data frame extensions (e.g., tibbles).}

\item{select}{A variable specified as:
\itemize{
\item a literal variable name (e.g., \code{column_name})
\item a character vector with the variable name (e.g., \code{"column_name"})
\item a positive integer, giving the position counting from the left
\item a negative integer, giving the position counting from the right.
}

The default returns the last column.
If the special value \code{0} or \code{"row.names"} is given, the row names of the
object (if any) are extracted.}

\item{name}{An optional argument that specifies the column to be used as
names for for the vector after extraction.
Specified in the same way as \code{select}.}

\item{...}{For use by future methods.}
}
\value{
A vector containing the extracted element.
}
\description{
\code{extract()} is similar to \code{$}. It extracts a single column or element from an object
(e.g., a data frame, list, )
}
\examples{
extract(mtcars, cyl, name = gear)
extract(mtcars, "cyl", name = gear)
extract(mtcars, -1, name = gear)
extract(mtcars, cyl, name = 0)
extract(mtcars, cyl, name = "row.names")
}
