% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_numeric.R
\name{to_numeric}
\alias{to_numeric}
\alias{data_to_numeric}
\alias{to_numeric.data.frame}
\title{Convert data to numeric}
\usage{
to_numeric(x, ...)

data_to_numeric(x, ...)

\method{to_numeric}{data.frame}(
  x,
  select = NULL,
  exclude = NULL,
  dummy_factors = TRUE,
  preserve_levels = FALSE,
  lowest = NULL,
  append = FALSE,
  ignore_case = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{A data frame, factor or vector.}

\item{...}{Arguments passed to or from other methods.}

\item{select}{Variables that will be included when performing the required
tasks. Can be either
\itemize{
\item a variable specified as a literal variable name (e.g., \code{column_name}),
\item a string with the variable name (e.g., \code{"column_name"}), or a character
vector of variable names (e.g., \code{c("col1", "col2", "col3")}),
\item a formula with variable names (e.g., \code{~column_1 + column_2}),
\item a vector of positive integers, giving the positions counting from the left
(e.g. \code{1} or \code{c(1, 3, 5)}),
\item a vector of negative integers, giving the positions counting from the
right (e.g., \code{-1} or \code{-1:-3}),
\item one of the following select-helpers: \code{starts_with("")}, \code{ends_with("")},
\code{contains("")}, a range using \code{:} or \code{regex("")},
\item or a function testing for logical conditions, e.g. \code{is.numeric()} (or
\code{is.numeric}), or any user-defined function that selects the variables
for which the function returns \code{TRUE} (like: \code{foo <- function(x) mean(x) > 3}),
\item ranges specified via literal variable names, select-helpers (except
\code{regex()}) and (user-defined) functions can be negated, i.e. return
non-matching elements, when prefixed with a \code{-}, e.g. \code{-ends_with("")},
\code{-is.numeric} or \code{-Sepal.Width:Petal.Length}. \strong{Note:} Negation means
that matches are \emph{excluded}, and thus, the \code{exclude} argument can be
used alternatively. For instance, \code{select=-ends_with("Length")} (with
\code{-}) is equivalent to \code{exclude=ends_with("Length")} (no \code{-}). In case
negation should not work as expected, use the \code{exclude} argument instead.
}

If \code{NULL}, selects all columns. Patterns that found no matches are silently
ignored, e.g. \code{find_columns(iris, select = c("Species", "Test"))} will just
return \code{"Species"}.}

\item{exclude}{See \code{select}, however, column names matched by the pattern
from \code{exclude} will be excluded instead of selected. If \code{NULL} (the default),
excludes no columns.}

\item{dummy_factors}{Transform factors to dummy factors (all factor levels as
different columns filled with a binary 0-1 value).}

\item{preserve_levels}{Logical, only applies if \code{x} is a factor. If \code{TRUE},
and \code{x} has numeric factor levels, these will be converted into the related
numeric values. If this is not possible, the converted numeric values will
start from 1 to number of levels.}

\item{lowest}{Numeric, indicating the lowest (minimum) value when converting
factors or character vectors to numeric values.}

\item{append}{Logical or string. If \code{TRUE}, recoded or converted variables
get new column names and are appended (column bind) to \code{x}, thus returning
both the original and the recoded variables. The new columns get a suffix,
based on the calling function: \code{"_r"} for recode functions, \code{"_n"} for
\code{to_numeric()}, \code{"_f"} for \code{to_factor()}, or \code{"_s"} for
\code{slide()}. If \code{append=FALSE}, original variables in \code{x} will be
overwritten by their recoded versions. If a character value, recoded
variables are appended with new column names (using the defined suffix) to
the original data frame.}

\item{ignore_case}{Logical, if \code{TRUE} and when one of the select-helpers or
a regular expression is used in \code{select}, ignores lower/upper case in the
search pattern when matching against variable names.}

\item{verbose}{Toggle warnings.}
}
\value{
A data frame of numeric variables.
}
\description{
Convert data to numeric by converting characters to factors and factors to
either numeric levels or dummy variables. The "counterpart" to convert
variables into factors is \code{to_factor()}.
}
\section{Selection of variables - \code{select} argument}{

For most functions that have a \code{select} argument the complete input data
frame is returned, even when \code{select} only selects a range of variables.
However, for \code{to_numeric()}, factors might be converted into dummies,
thus, the number of variables of the returned data frame no longer match
the input data frame. Hence, when \code{select} is used, \emph{only} those variables
(or their dummies) specified in \code{select} will be returned. Use \code{append=TRUE}
to also include the original variables in the returned data frame.
}

\examples{
to_numeric(head(ToothGrowth))
to_numeric(head(ToothGrowth), dummy_factors = FALSE)

# factors
x <- as.factor(mtcars$gear)
to_numeric(x, dummy_factors = FALSE)
to_numeric(x, dummy_factors = FALSE, preserve_levels = TRUE)

}
