% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_arrange.R
\name{data_arrange}
\alias{data_arrange}
\title{Arrange rows by column values}
\usage{
data_arrange(data, select = NULL, safe = TRUE)
}
\arguments{
\item{data}{A data frame, or an object that can be coerced to a data frame.}

\item{select}{Character vector of column names. Use a dash just before column
name to arrange in decreasing order, for example \code{"-x1"}.}

\item{safe}{Do not throw an error if one of the variables specified doesn't
exist.}
}
\value{
A data frame.
}
\description{
\code{data_arrange()} orders the rows of a data frame by the values of selected
columns.
}
\examples{
\dontrun{
# Arrange using several variables
data_arrange(head(mtcars), "gear", "carb")

# Arrange in decreasing order
data_arrange(head(mtcars), "-carb")

# Throw an error if one of the variables specified doesn't exist
data_arrange(head(mtcars), "gear", "foo", safe = FALSE)
}
}
