## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(datefixR)

## ---- echo = TRUE-------------------------------------------------------------
bad.dates <- data.frame(
  id = seq(5),
  some.dates = c(
    "02/05/92",
    "01-04-2020",
    "1996/05/01",
    "2020-05-01",
    "02-04-96"
  ),
  some.more.dates = c(
    "01 03 2015",
    "2nd January 2010",
    "01/05/1990",
    "03-Dec-2012",
    "02 April 2020"
  )
)
knitr::kable(bad.dates)

## -----------------------------------------------------------------------------
fixed.dates <- fix_date_df(
  bad.dates,
  c("some.dates", "some.more.dates")
)
knitr::kable(fixed.dates)

## -----------------------------------------------------------------------------
fix_date_char("01 02 2014")

## -----------------------------------------------------------------------------
fix_date_char("7 de septiembre del 2014")

## -----------------------------------------------------------------------------
fix_date_char("01 02 2014", format = "mdy")

## -----------------------------------------------------------------------------
fix_date_char("July 4th, 1776")

## -----------------------------------------------------------------------------
fix_date_char("1992")

## -----------------------------------------------------------------------------
fix_date_char("1992", day.impute = 1, month.impute = 1)

## -----------------------------------------------------------------------------
fix_date_char("1992", month.impute = NA)

## ---- eval = FALSE------------------------------------------------------------
#  fix_date_char("1992", month.impute = NULL)
#  # ERROR

## -----------------------------------------------------------------------------
example.df <- data.frame(
  id = seq(1, 3),
  some.dates = c("2014", "April 1990", "Mar 19")
)
fix_date_df(example.df, "some.dates", day.impute = 1, month.impute = 1)

## -----------------------------------------------------------------------------
date <- as.numeric(as.Date("2023-01-17"))
print(date)
fix_date_char(as.character(date))

## -----------------------------------------------------------------------------
fix_date_char("44941", excel = TRUE)

## -----------------------------------------------------------------------------
citation("datefixR")

