% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrations_get.R
\name{extract_calibrations_dateliferesult}
\alias{extract_calibrations_dateliferesult}
\title{Extract secondary calibrations from a given \code{datelifeResult} object}
\usage{
extract_calibrations_dateliferesult(input = NULL, each = FALSE)
}
\arguments{
\item{input}{A \code{datelifeResult} object.}

\item{each}{Boolean, default to \code{FALSE}: all calibrations are returned in
the same \code{data.frame}. If \code{TRUE}, calibrations from each chronogram are returned
in separate data frames.}
}
\value{
An object of class \code{datelifeCalibrations}, i.e., a \code{data.frame} (if
\code{each = FALSE}) or a list of \code{data.frames} (if \code{each = TRUE}) of secondary
calibrations, for each pair of taxon names in \code{input}. The attribute
\code{chronograms} stores the \code{input} data from which the calibrations were extracted.
}
\description{
This function extracts node ages for each taxon
pair given as \code{input}. It applies the congruification method described in Eastman et al.
(2013) \doi{10.1111/2041-210X.12051},
to create a matrix of suitable secondary calibrations for each taxon pair.
Congruification is implemented with the function \code{\link[geiger:congruify.phylo]{geiger::congruify.phylo()}}.
}
\details{
The function calls summarize_datelife_result()] with
\verb{summary_format = "phylo_all" to go from a }datelifeResult\verb{object to a}phylo\code{or}multiPhylo` object that will be passed to
\code{\link[=extract_calibrations_phylo]{extract_calibrations_phylo()}}.
}
