% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opentree_chronograms.R
\docType{data}
\name{opentree_chronograms}
\alias{opentree_chronograms}
\title{Chronogram database}
\format{
A list of four elements, containing data from OpenTree of Life chronograms
\describe{
\item{authors}{A list of lists of author names of the original studies that
published chronograms in the Open Tree of Life database.}
\item{curators}{A list of lists of curator names that uplodaded chronograms
to the Open Tree of Life database.}
\item{studies}{A list of study identifiers.}
\item{trees}{A \code{multiPhylo} object storing the chronograms from Open Tree of
Life database.}
}
}
\source{
\url{http://opentreeoflife.org}
}
\usage{
opentree_chronograms
}
\description{
Now storing >200 chronograms from Open Tree of Life
}
\details{
Generated with
opentree_chronograms <- get_otol_chronograms()
usethis::use_data(opentree_chronograms, overwrite = T)
and updated with update_datelife_cache()
}
\keyword{chronogram}
\keyword{dates}
\keyword{million}
\keyword{myrs}
\keyword{opentree}
\keyword{phylogeny}
\keyword{time}
\keyword{years}
