% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_report.R
\name{create_report}
\alias{create_report}
\title{Create Report}
\usage{
create_report(
  DD.dict,
  DS.data,
  sex.split = FALSE,
  sex.name = NULL,
  start = 1,
  end = 1,
  non.NA.missing.codes = NA,
  output.path = tempdir(),
  open.html = TRUE,
  fn.stem = "Report"
)
}
\arguments{
\item{DD.dict}{Data dictionary.}

\item{DS.data}{Data set.}

\item{sex.split}{When TRUE, split reports by the field named as defined by the sex.name variable.}

\item{sex.name}{Character string specifying the name of the sex field.}

\item{start}{Staring index of the first select trait.}

\item{end}{Ending index of the last selected trait.}

\item{non.NA.missing.codes}{A user-defined vector of numerical missing value codes (e.g., -9999).}

\item{output.path}{Path to the folder in which to create the HTML report document.}

\item{open.html}{If TRUE, open the HTML report document in the web browser.}

\item{fn.stem}{File name stem.}
}
\value{
Full path to the HTML report document.
}
\description{
This function calls eval_function to generate a textual and graphical report of the selected variables in HTML format, and optionally opens it in the web browser.
}
\examples{
\donttest{
data(ExampleB)
create_report(DD.dict.B, DS.data.B, sex.split=TRUE, sex.name= "SEX",
   start = 3, end = 7, non.NA.missing.codes=c(-9999,-4444),
   output.path= tempdir(), open.html = FALSE)
}
}
