% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbn_inference.R
\name{predict_dt}
\alias{predict_dt}
\title{Performs inference over a test data set with a GBN}
\usage{
predict_dt(fit, dt, obj_nodes, verbose = T)
}
\arguments{
\item{fit}{the fitted bn}

\item{dt}{the test data set}

\item{obj_nodes}{the nodes that are going to be predicted. They are all predicted at the same time}

\item{verbose}{if TRUE, displays the metrics and plots the real values against the predictions}
}
\value{
the prediction results
}
\description{
Performs inference over a test data set, plots the results
and gives metrics of the accuracy of the results.
}
\examples{
size = 3
data(motor)
dt_train <- motor[200:2500]
dt_val <- motor[2501:3000]

# With a DBN 
obj <- c("pm_t_0", "torque_t_0")
net <- learn_dbn_struc(dt_train, size)
f_dt_train <- fold_dt(dt_train, size)
f_dt_val <- fold_dt(dt_val, size)
fit <- fit_dbn_params(net, f_dt_train, method = "mle")
res <- suppressWarnings(predict_dt(fit, f_dt_val, obj_nodes = obj, verbose = FALSE))

# With a Gaussian BN directly from bnlearn
obj <- c("pm", "torque")
net <- bnlearn::mmhc(dt_train)
fit <- bnlearn::bn.fit(net, dt_train, method = "mle")
res <- suppressWarnings(predict_dt(fit, dt_val, obj_nodes = obj, verbose = FALSE))
}
