% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbn_inference.R
\name{smooth_ts}
\alias{smooth_ts}
\title{Performs smoothing with the GDBN over a data set}
\usage{
smooth_ts(
  dt,
  fit,
  size,
  obj_vars,
  ini = dim(dt)[1],
  len = ini - 1,
  print_res = TRUE,
  plot_res = TRUE,
  prov_ev = NULL
)
}
\arguments{
\item{dt}{data.table object with the TS data}

\item{fit}{dbn.fit object}

\item{size}{number of time slices of the net}

\item{obj_vars}{variables to be predicted. Should be in the oldest time step}

\item{ini}{starting point in the data set to smooth}

\item{len}{length of the smoothing}

\item{print_res}{if TRUE prints the mae and sd metrics of the smoothing}

\item{plot_res}{if TRUE plots the results of the smoothing}

\item{prov_ev}{variables to be provided as evidence in each smoothing step. Should be in the oldest time step}
}
\value{
the results of the smoothing
}
\description{
Given a dbn.fit object, the size of the net and a folded data.set,
performs a smoothing of a trajectory. Smoothing is the opposite of 
forecasting: given a starting point, predict backwards in time to obtain
the time series that generated that point.
}
