% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure_learning_natpsoho.R
\name{natPsoho}
\alias{natPsoho}
\title{Learn a DBN structure with a PSO approach}
\usage{
natPsoho(
  dt,
  size,
  f_dt = NULL,
  n_inds = 50,
  n_it = 50,
  in_cte = 1,
  gb_cte = 0.5,
  lb_cte = 0.5,
  v_probs = c(10, 65, 25),
  r_probs = c(-0.5, 1.5),
  score = "bge",
  p = 0.06,
  cte = TRUE
)
}
\arguments{
\item{dt}{a data.table with the data of the network to be trained}

\item{size}{Maximum number of timeslices of the DBN allowed. Markovian order 1 equals size 2, and so on}

\item{f_dt}{previously folded dataset, in case some specific rows have to be removed after the folding}

\item{n_inds}{Number of particles used in the algorithm}

\item{n_it}{Maximum number of iterations that the algorithm can perform}

\item{in_cte}{parameter that varies the effect of the inertia}

\item{gb_cte}{parameter that varies the effect of the global best}

\item{lb_cte}{parameter that varies the effect of the local best}

\item{v_probs}{vector that defines the random velocity initialization probabilities}

\item{r_probs}{vector that defines the range of random variation of gb_cte and lb_cte}

\item{score}{bnlearn score function used}

\item{p}{parameter of the truncated geometric distribution for sampling edges}

\item{cte}{a boolean that determines whether the inertia, global best and local best parameters remain constant or vary as the algorithm progresses. Inertia and local best values decrease as the global best increases, to favor exploration at first and exploitation at the end}
}
\value{
A 'dbn' object with the structure of the best network found
}
\description{
Given a dataset and the desired Markovian order, this function returns a DBN
structure ready to be fitted.
Original algorithm at https://link.springer.com/chapter/10.1007/978-3-030-86271-8_14
}
\keyword{internal}
