% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-expand.R
\name{complete.tbl_lazy}
\alias{complete.tbl_lazy}
\title{Complete a SQL table with missing combinations of data}
\usage{
\method{complete}{tbl_lazy}(data, ..., fill = list())
}
\arguments{
\item{data}{A lazy data frame backed by a database query.}

\item{...}{Specification of columns to expand. See \link[tidyr:expand]{tidyr::expand} for
more details.}

\item{fill}{A named list that for each variable supplies a single value to
use instead of NA for missing combinations.}
}
\value{
Another \code{tbl_lazy}. Use \code{\link[=show_query]{show_query()}} to see the generated
query, and use \code{\link[=collect.tbl_sql]{collect()}} to execute the query
and return data to R.
}
\description{
Turns implicit missing values into explicit missing values. This is a method
for the \code{\link[tidyr:complete]{tidyr::complete()}} generic.
}
\examples{
\dontshow{if (rlang::is_installed("tidyr", version = "1.0.0")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
df <- memdb_frame(
  group = c(1:2, 1),
  item_id = c(1:2, 2),
  item_name = c("a", "b", "b"),
  value1 = 1:3,
  value2 = 4:6
)

df \%>\% tidyr::complete(group, nesting(item_id, item_name))

# You can also choose to fill in missing values
df \%>\% tidyr::complete(group, nesting(item_id, item_name), fill = list(value1 = 0))
\dontshow{\}) # examplesIf}
}
