% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db-sql.R
\name{sql_query_insert}
\alias{sql_query_insert}
\alias{sql_query_append}
\alias{sql_query_update_from}
\alias{sql_query_upsert}
\alias{sql_query_delete}
\title{Generate SQL for Insert, Update, Upsert, and Delete}
\usage{
sql_query_insert(
  con,
  x_name,
  y,
  by,
  ...,
  conflict = c("error", "ignore"),
  returning_cols = NULL,
  method = NULL
)

sql_query_append(con, x_name, y, ..., returning_cols = NULL)

sql_query_update_from(
  con,
  x_name,
  y,
  by,
  update_values,
  ...,
  returning_cols = NULL
)

sql_query_upsert(
  con,
  x_name,
  y,
  by,
  update_cols,
  ...,
  returning_cols = NULL,
  method = NULL
)

sql_query_delete(con, x_name, y, by, ..., returning_cols = NULL)
}
\arguments{
\item{con}{Database connection.}

\item{x_name}{Name of the table to update.}

\item{y}{A lazy tbl.}

\item{by}{An unnamed character vector giving the key columns. The key columns
must exist in both \code{x} and \code{y}. Keys typically uniquely identify each row,
but this is only enforced for the key values of \code{y} when \code{rows_update()},
\code{rows_patch()}, or \code{rows_upsert()} are used.

By default, we use the first column in \code{y}, since the first column is
a reasonable place to put an identifier variable.}

\item{...}{Other parameters passed onto methods.}

\item{conflict}{For \code{rows_insert()}, how should keys in \code{y} that conflict
with keys in \code{x} be handled? A conflict arises if there is a key in \code{y}
that already exists in \code{x}.

One of:
\itemize{
\item \code{"error"}, the default, will error if there are any keys in \code{y} that
conflict with keys in \code{x}.
\item \code{"ignore"} will ignore rows in \code{y} with keys that conflict with keys in
\code{x}.
}}

\item{returning_cols}{Optional. Names of columns to return.}

\item{method}{Optional. The method to use.}

\item{update_values}{A named SQL vector that specify how to update the columns.}

\item{update_cols}{Names of columns to update.}
}
\value{
A SQL query.
}
\description{
These functions generate the SQL used in \code{rows_*(in_place = TRUE)}.
}
\details{
Insert Methods
\subsection{\code{"where_not_exists"}}{

The default for most databases.

\if{html}{\out{<div class="sourceCode">}}\preformatted{INSERT INTO x_name
SELECT *
FROM y
WHERE NOT EXISTS <match on by columns>
}\if{html}{\out{</div>}}
}

\subsection{\code{"on_conflict"}}{

Supported by:
\itemize{
\item Postgres
\item SQLite
}

This method uses the \verb{ON CONFLICT} clause and therefore requires a unique
index on the columns specified in \code{by}.
}

Upsert Methods
\subsection{\code{"merge"}}{

The upsert method according to the SQL standard. It uses the \code{MERGE} statement

\if{html}{\out{<div class="sourceCode">}}\preformatted{MERGE INTO x_name
USING y
  ON <match on by columns>
WHEN MATCHED THEN
  UPDATE SET ...
WHEN NOT MATCHED THEN
  INSERT ...
}\if{html}{\out{</div>}}
}

\subsection{\code{"on_conflict"}}{

Supported by:
\itemize{
\item Postgres
\item SQLite
}

This method uses the \verb{ON CONFLICT} clause and therefore requires a unique
index on the columns specified in \code{by}.
}

\subsection{\code{"cte_update"}}{

Supported by:
\itemize{
\item Postgres
\item SQLite
\item Oracle
}

The classical way to upsert in Postgres and SQLite before support for
\verb{ON CONFLICT} was added. The update is done in a CTE clause and the unmatched
values are then inserted outside of the CTE.
}
}
\examples{
lf <- lazy_frame(
  carrier = c("9E", "AA"),
  name = c("Endeavor Air Inc.", "American Airlines Inc."),
  con = simulate_postgres()
)

sql_query_upsert(
  simulate_postgres(),
  ident("airlines"),
  lf,
  by = "carrier",
  update_cols = "name"
)
}
