% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dcTreeConnectivity.r
\name{dcTreeConnectivity}
\alias{dcTreeConnectivity}
\title{Function to calculate the sparse connectivity matrix between parents and children from a phylo-formatted phylogenetic tree}
\usage{
dcTreeConnectivity(phy, verbose = T)
}
\arguments{
\item{phy}{an object of class 'phylo'}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to TRUE for display}
}
\value{
a sparse matrix of \eqn{Nnode} X \eqn{Ntip+Nnode}, where \eqn{Ntip} and
\eqn{Nnode} are the number of tips and internal nodes. A non-zero entry
indicates a pair of a parent and its child.
}
\description{
\code{dcTreeConnectivity} is supposed to calculate the sparse
connectivity matrix between parents and children from a phylo-formatted
phylogenetic tree. The matrix has internal nodes (in rows) and tips
plus internal nodes (in columns). For a row (an internal node; as a
parent), the non-zeros indicate all its descendants/children.
}
\note{
None
}
\examples{
# a newick tree
tree <- "(((t1:5,t2:5):2,(t3:4,t4:4):3):2,(t5:4,t6:4):6);"
phy <- ape::read.tree(text=tree)

# connectivity matrix
res <- dcTreeConnectivity(phy)
dim(res)
# convert to a full Matrix
as.matrix(res)
}
\seealso{
\code{\link{dcTreeConnectivity}}
}

