% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-files-manifest.R
\name{check_files_manifest}
\alias{check_files_manifest}
\title{Check that files are present in manifest}
\usage{
check_files_manifest(
  manifest,
  filenames,
  strict = FALSE,
  success_msg = "All required files are present in manifest",
  fail_msg = "Some files may be missing from manifest"
)
}
\arguments{
\item{manifest}{The manifest as a data frame or tibble}

\item{filenames}{File names to look for in the \code{path} column of the manifest}

\item{strict}{If \code{FALSE}, return a \code{"check_warn"} object; if \code{TRUE}, return a
\code{"check_fail"} object}

\item{success_msg}{Message indicating the check succeeded.}

\item{fail_msg}{Message indicating the check failed.}
}
\value{
A condition object indicating whether the files are present in the
\code{path} column of the manifest
}
\description{
Given a manifest and vector of file names, checks that the file names appear
in the manifest. This is useful to ensure that metadata files (not just data
files) are included in the manifest for upload.
}
\examples{
manifest <- data.frame(
  path = c("individual_metadata.csv", "biospecimen_metadata.csv"),
  parent = c("syn123", "syn123")
)
check_files_manifest(
  manifest,
  c(
    "individual_metadata.csv",
    "biospecimen_metadata.csv",
    "assay_metadata.csv"
  )
)
}
